<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\ActivityModel;
use App\Models\BiodataModel;
use App\Models\EducationModel;
use App\Models\CertificateModel;

class DashboardController extends BaseController
{
    protected $activityModel;
    protected $biodataModel;
    protected $educationModel;
    protected $certificateModel;

    public function __construct()
    {
        $this->activityModel = new ActivityModel();
        $this->biodataModel = new BiodataModel();
        $this->educationModel = new EducationModel();
        $this->certificateModel = new CertificateModel();
    }

    public function index()
    {
        $userRole = session()->get('user_role');
        
        // Untuk biodata, cek apakah sudah ada (hanya satu biodata untuk portfolio personal)
        $biodataExists = $userRole === 'admin_biodata' ? ($this->biodataModel->first() ? 1 : 0) : 0;
        
        $data = [
            'title' => 'Dashboard Admin',
            'userRole' => $userRole,
            'stats' => [
                'activities' => $userRole === 'admin_activities' ? $this->activityModel->countAllResults() : 0,
                'biodata' => $biodataExists,
                'education' => $userRole === 'admin_education' ? $this->educationModel->countAllResults() : 0,
            ]
        ];

        return view('admin/dashboard', $data);
    }
}

